import java.awt.*;
import misc.Debug;
/**
 * A StepControlPanel object is the user interface for a StepControl object.
 * It's not visible outside the package.
 *
 * @version 0.10 12 Mai 1997
 * @author Gunter Weiss
 */
class StepControlPanel extends Panel {

  private protected Button stepButton;
  protected  StepControl stcontrol;
  protected Scrollbar slider1;
  private Label label1;

  protected StepControlPanel( StepControl stcontrol ) {
    //super( control.name, 1, 3 );
    this .stcontrol = stcontrol;
    setLayout( new GridLayout(3,1,3,3 ));
    label1 = new Label("Steps / s",Label.CENTER);
    label1. setFont(new Font("Courier",Font.PLAIN,14));
    slider1 = new Scrollbar( Scrollbar.HORIZONTAL, 0, 30, 0, 100 ) ;
    stepButton = new Button("Step");
    add(label1);
    add(slider1);
    add(stepButton);
    validate();
    show();

  }

  /**
  * Overrides action() of class Component.
  */
	public boolean action( Event e, Object arg ) {
		if ( e.target == stepButton ) {
		   stcontrol. setSteps(slider1.getValue());
		   return true;
		}
		if ( e.target == slider1 ) {
		   stcontrol. setSteps(slider1.getValue());
		   return true;
		}
		return super.action( e, arg );
	}

	public void finish() {
	  //super.finish();
		slider1 = null;
		stepButton = null;
		Debug.out( "StepControlpanel.finish: called" );
	}

	protected void finalize() {
		Debug.outa("StepControlpanel.finalize called");
		try { super.finalize(); } catch ( Throwable _x ) { ; }
	}
} // End of class StepControlPanel
